c=======================================================================
      subroutine correct(x)
c=======================================================================
      include 'commons.h'
      complex*8 x(0:(nx+1),0:(ny+1),0:(nz+1))
c
      q2=omega**2/(c_zero**2*qual_fac2)
      fac0 = q2/(2.0*omega)
c
      do 3000 k=1,nz
         ntz = iabs(k-nsrcz)
         z1  = real(k-1)*hz+az
      do 3200 j=1,ny
         nty = iabs(j-nsrcy)
         y1  = real(j-1)*hy+ay
      do 3400 i=1,nx
         ntx = iabs(i-nsrcx)
         x1  = real(i-1)*hx+ax
         npt = max(ntx,nty,ntz)
         if(npt.ne.0) then
            call eval_int_c(npt,srcxx,srcyy,srczz,x1,y1,z1,theint)
            x(i,j,k) = exp(fac0*theint)*x(i,j,k)
         endif
 3400 continue
 3200 continue
 3000 continue
c
 9999 return
      end

c=======================================================================
      subroutine eval_int_c(npt,x0,y0,z0,x1,y1,z1,theint)
c=======================================================================
c
      hdx = abs(x0-x1)/real(npt)
      hdy = abs(y0-y1)/real(npt)
      hdz = abs(y0-y1)/real(npt)
      hd  = sqrt((x0-x1)**2+(y0-y1)**2+(z0-z1)**2)/real(npt)
c
      theint = 0.0
      do 1000 i = 1,npt
        px = x0 + real(i)*hdx
        py = y0 + real(i)*hdy
        pz = z0 + real(i)*hdz
        theint = theint + cc(px,py,pz)
 1000 continue
      theint = hd*theint
c
 9999 return
      end

c=======================================================================
      subroutine smoothGS(ahd,xh,fh,nxx,nyy,iterSGS)
c=======================================================================
      complex*8 ahd(nxx,nyy),xh(nxx,nyy),fh(nxx,nyy)
      complex*8 ctmp
c
c ....smoothing: Symmetric-Gauss-Seidel iteration
c
      nxxm1=nxx-1
      nyym1=nyy-1
c
      do 8888 iter=1,iterSGS
c
      j=1
      i=1
      xh(i,j)=(fh(i,j)+2.*(xh(i+1,j)+xh(i,j+1)))/ahd(i,j)
      do 1000 i=2,nxxm1
 1000   xh(i,j)=(fh(i,j)+2.*xh(i,j+1)+xh(i-1,j)+xh(i+1,j))/ahd(i,j)
      i=nxx
      xh(i,j)=(fh(i,j)+2.*(xh(i-1,j)+xh(i,j+1)))/ahd(i,j)
c
      do 2000 j=2,nyym1
      i=1
      xh(i,j)=(fh(i,j)+2.*xh(i+1,j)+xh(i,j-1)+xh(i,j+1))/ahd(i,j)
      do 2200 i=2,nxxm1
        ctmp =xh(i-1,j)+xh(i+1,j)+xh(i,j-1)+xh(i,j+1)
 2200   xh(i,j)=(fh(i,j)+ctmp)/ahd(i,j)
      i=nxx
      xh(i,j)=(fh(i,j)+2.*xh(i-1,j)+xh(i,j-1)+xh(i,j+1))/ahd(i,j)
 2000 continue
c
      j=nyy
      i=1
      xh(i,j)=(fh(i,j)+2.*(xh(i+1,j)+xh(i,j-1)))/ahd(i,j)
      do 3000 i=2,nxxm1
 3000   xh(i,j)=(fh(i,j)+2.*xh(i,j-1)+xh(i-1,j)+xh(i+1,j))/ahd(i,j)
      i=nxx
      xh(i,j)=(fh(i,j)+2.*(xh(i-1,j)+xh(i,j-1)))/ahd(i,j)
c
c.... sweep in the opposite direction
c
      j=nyy
      i=nxx
      xh(i,j)=(fh(i,j)+2.*(xh(i-1,j)+xh(i,j-1)))/ahd(i,j)
      do 4000 i=nxxm1,2,-1
 4000   xh(i,j)=(fh(i,j)+2.*xh(i,j-1)+xh(i-1,j)+xh(i+1,j))/ahd(i,j)
      i=1
      xh(i,j)=(fh(i,j)+2.*(xh(i+1,j)+xh(i,j-1)))/ahd(i,j)
c
      do 5000 j=nyym1,2,-1
      i=nxx
      xh(i,j)=(fh(i,j)+2.*xh(i-1,j)+xh(i,j-1)+xh(i,j+1))/ahd(i,j)
      do 5200 i=nxxm1,2,-1
        ctmp =xh(i-1,j)+xh(i+1,j)+xh(i,j-1)+xh(i,j+1)
 5200   xh(i,j)=(fh(i,j)+ctmp)/ahd(i,j)
      i=1
      xh(i,j)=(fh(i,j)+2.*xh(i+1,j)+xh(i,j-1)+xh(i,j+1))/ahd(i,j)
 5000 continue
c
      j=1
      i=nxx
      xh(i,j)=(fh(i,j)+2.*(xh(i-1,j)+xh(i,j+1)))/ahd(i,j)
      do 6000 i=nxxm1,2,-1
 6000   xh(i,j)=(fh(i,j)+2.*xh(i,j+1)+xh(i-1,j)+xh(i+1,j))/ahd(i,j)
      i=1
      xh(i,j)=(fh(i,j)+2.*(xh(i+1,j)+xh(i,j+1)))/ahd(i,j)
c
 8888 continue
c
 9999 return
      end

c=======================================================================
      subroutine residual(nnnx,nnny,ahd,xh,fh,x,rhs,wksp,iter2g,relRES)
c=======================================================================
      include 'commons.h'
      complex*8 ahd(nnnx,nnny),xh(nnnx,nnny),fh(nnnx,nnny)
      complex*8 x(1),rhs(mx,my,ndmnx,ndmny),wksp(nx,ny)
      complex*8 ctmp
c
      nxm1=nx-1
      nym1=ny-1
c
      jj=1
      j = idgrid*(jj-1)+1
      ii=1
      i = idgrid*(ii-1)+1
      ctmp = 2.*(xh(i+1,j)+xh(i,j+1))-ahd(i,j)*xh(i,j)
      wksp(ii,jj)=fh(i,j)+ctmp
      do 1000 ii=2,nxm1
        i = idgrid*(ii-1)+1
        ctmp = 2.*xh(i,j+1)+xh(i-1,j)+xh(i+1,j)-ahd(i,j)*xh(i,j)
        wksp(ii,jj)=fh(i,j)+ctmp
 1000 continue
      ii=nx
      ctmp = 2.*(xh(i-1,j)+xh(i,j+1))-ahd(i,j)*xh(i,j)
      wksp(ii,jj)=fh(i,j)+ctmp
c
      do 2000 jj=2,nym1
      j = idgrid*(jj-1)+1
      ii=1
      i = idgrid*(ii-1)+1
      ctmp = 2.*xh(i+1,j)+xh(i,j-1)+xh(i,j+1)-ahd(i,j)*xh(i,j)
      wksp(ii,jj)=fh(i,j)+ctmp
      do 2200 ii=2,nxm1
        i = idgrid*(ii-1)+1
        ctmp =xh(i-1,j)+xh(i+1,j)+xh(i,j-1)+xh(i,j+1)-ahd(i,j)*xh(i,j)
        wksp(ii,jj)=fh(i,j)+ctmp
 2200 continue
      ii=nx
      i = idgrid*(ii-1)+1
      ctmp = 2.*xh(i-1,j)+xh(i,j-1)+xh(i,j+1)-ahd(i,j)*xh(i,j)
      wksp(ii,jj)=fh(i,j)+ctmp
 2000 continue
c
      jj=ny
      j = idgrid*(jj-1)+1
      ii=1
      i = idgrid*(ii-1)+1
      ctmp = 2.*(xh(i+1,j)+xh(i,j-1))-ahd(i,j)*xh(i,j)
      wksp(ii,jj)=fh(i,j)+ctmp
      do 3000 ii=2,nxm1
        i = idgrid*(ii-1)+1
        ctmp = 2.*xh(i,j-1)+xh(i-1,j)+xh(i+1,j)-ahd(i,j)*xh(i,j)
        wksp(ii,jj)=fh(i,j)+ctmp
 3000 continue
      ii=nx
      i = idgrid*(ii-1)+1
      ctmp = 2.*(xh(i-1,j)+xh(i,j-1))-ahd(i,j)*xh(i,j)
      wksp(ii,jj)=fh(i,j)+ctmp
c
      resid=0.0
      do 20 j=1,nym1
      do 20 i=1,nxm1
         resid=resid+cabs(wksp(i,j))**2
  20  continue
      resid = sqrt(resid)*hx
      relRES = resid/res0
      print'(" rel_L2_res(",i2,")  =",1pe10.2)',iter2g,relRES
c
      if(iter2g.le.2) goto 450
c
      do 31 i=1,nx
         wksp(i,1) = 0.
*         wksp(i,1) = 0.5*wksp(i,1)
 31   continue
      do 32 i=1,nx
         wksp(i,ny)= 0.
*         wksp(i,ny)= 0.5*wksp(i,ny)
 32   continue
      do 35 j=1,ny
         wksp(1,j) = 0.
         wksp(nx,j)= 0.
*         wksp(1,j) = 0.5*wksp(1,j)
*         wksp(nx,j)= 0.5*wksp(nx,j)
 35   continue
c
 450  continue
c
c.... array exchange for "rhs=fac*wksp"
c
      fac=dble(idgrid*idgrid)
c
      do 40 jj = 1,ndmny
         ntjj = (jj-1)*(my-1)
      do 40 ii = 1,ndmnx
         ntii = (ii-1)*(mx-1)
      do 40 j  = 1,my
         ntty = ntjj+j
      do 40 i  = 1,mx
         nttx = ntii+i
         rhs(i,j,ii,jj)=fac*wksp(nttx,ntty)
 40   continue
c
c.....set initial guess for the coarse grid problem
c
      do 60 i=1,neqn
 60     x(i)=0.0
c
 9999 return
      end

