c=======================================================================
        real*4 function cc(x,y,z)
c=======================================================================
        include 'commons.h'
c
        if(ncc.eq.1)then
           cc = 2.d0
        else if (ncc.eq.2) then
           temp = half+0.0001
           if (z.le.temp) then
              cc = 2.d0
           else
              cc = 2.0d0+sin(4.*pi*x)*sin(6.*pi*y)*cos(8.*pi*z)
*              cc = 3.0d0+sin(6.0*pi*z)
           endif
        elseif(ncc.eq.3) then
           temp = 1.0/9.0
           xbar = x - mod(x,temp)
           ybar = y - mod(y,temp)
*           cc=2.5+0.5*(mod(23.0*xbar+19.0*ybar,1.0)+mod(31.0*ybar,1.0))
           cc = 2.0 +mod(23.0*xbar+19.0*ybar,1.0)+mod(31.0*ybar,1.0)
        else
           cc = 1.0d0
        endif
c
        return
        end

c=======================================================================
        complex*8 function true(x,y,z)
c=======================================================================
        complex*8 phi
        include 'commons.h'
c
        true = phi(x)*phi(y)*phi(z)/(omega**2)
        return
        end

c=======================================================================
        complex*8 function r1prhs(x,y,z)
c=======================================================================
        complex*8 phi
        complex*8 phix,phiy,phiz,wave_num2
        include 'commons.h'

        if(iddirac.ne.1) then
          phix = phi(x)
          phiy = phi(y)
          phiz = phi(z)
          omega2 = omega**2
          wave_num2 = 1.d0/(cc(x,y,z)**2) +im*q*q/omega2
          r1prhs = (3.d0-wave_num2)*phix*phiy*phiz
     &            + 2.d0*(phiy*phiz+phix*phiz+phix*phiy)
        else
          r1prhs =0.0d0
        endif
c
        return
        end

c=======================================================================
        complex*8 function phi(x)
c=======================================================================
        include 'commons.h'
        complex*8 tmp1,tmp2
c
        tmp1= omega*(x-1.0d0)*(0.0d0,1.0d0)
        tmp2=-omega*  x   *(0.0d0,1.0d0)
        phi = cexp(tmp1)+cexp(tmp2)-2.0d0
        return
        end

c=======================================================================
      subroutine rhstrue(rhs,truev)
c=======================================================================
      include 'commons.h'
      complex*8 r1prhs,true
      complex*8 rhs(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 truev(0:(nx+1),0:(ny+1),0:(nz+1))
c
      temp = (0.d0,0.d0)
      nxp1 = nx+1
      nyp1 = ny+1
      nzp1 = nz+1
      do 10 k = 0,nzp1
      do 10 j = 0,nyp1
      do 10 i = 0,nxp1
        rhs(i,j,k)  = temp
 10     truev(i,j,k)= temp
c
      hh = hx**2
      if(iddirac.eq.1) goto 3333
c
      do 1000 k = 1, nz
          pz = hz*dble(k-1)+az
      do 1000 j = 1, ny
          py = hy*dble(j-1)+ay
      do 1000 i = 1, nx
          px = hx*dble(i-1)+ax
          rhs(i,j,k)  = r1prhs(px,py,pz)*hh
          truev(i,j,k)= true(px,py,pz)
 1000 continue
      goto 9999
c
 3333 continue

      nsrcx = (nx+1)/2
      nsrcy = (ny+1)/2
      nsrcz = 1
c
      srcxx = ax+dble(nsrcx-1)*hx
      srcyy = ay+dble(nsrcy-1)*hy
      srczz = az+dble(nsrcz-1)*hz
      print'(" the source   =  (",3f9.4," )")',srcxx,srcyy,srczz
      rhs(nsrcx,nsrcy,nsrcz) = srcmag
c
 9999 return
      end

c=======================================================================
      subroutine iguess(nx,ny,nz,x)
c=======================================================================
      complex*8 x(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 ctmp
c
      nxp1 = nx+1
      nyp1 = ny+1
      nzp1 = nz+1
      ctmp = (0.0,0.0)
c
      do 1000 k = 0,nzp1
      do 1000 j = 0,nyp1
      do 1000 i = 0,nxp1
          x(i,j,k) = ctmp
 1000 continue
c
      return
      end

c=======================================================================
      subroutine c_average
c=======================================================================
      include 'commons.h'
c
      jump = 3
      c_zero= 0.d0
      icount=0
      do 1000 k = 1,nz,jump
          pz = hz*dble(k-1)+az
      do 1000 j = 1,ny,jump
          py = hy*dble(j-1)+ay
      do 1000 i = 1,nx,jump
          px = hx*dble(i-1)+ax
         c_zero = c_zero + cc(px,py,pz)**2
         icount=icount+1
 1000 continue
      temp = dble(icount)
      c_zero= sqrt(c_zero/temp)
c
 9999 return
      end
