c=======================================================================
      subroutine driver(a,ao,x,r,p,ap,truev,u,b,wksp)
c=======================================================================
      include 'commons.h'
      complex*8 a(1),ao(1),p(1),ap(1)
      complex*8 x(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 r(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 u(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 b(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 truev(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 wksp(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 ctmp0
c
      ctmp0= (0.0,0.0)
      tol5 = 5.*tol
      ittlCGNR= 0
      if(qual_fac2.lt.0.0 .and. idautodamp.ne.1) then
         tolCGNR=tol
         itmCGNR=itmax
         itmARTDI=1
      else
         itmCGNR=2*(nx-1)
         itmARTDI=itmax
      endif
c
      call iguess(nx,ny,nz,p)
      call iguess(nx,ny,nz,ap)
      call iguess(nx,ny,nz,x)
      call iguess(nx,ny,nz,u)
      call iguess(nx,ny,nz,b)
      call iguess(nx,ny,nz,wksp)
c
      call diagonal(a,ao)
      call rhstrue(b,truev)
      do 1000 k = 1,nz
      do 1000 j = 1,ny
      do 1000 i = 1,nx
        r(i,j,k) = b(i,j,k)
 1000 continue
      icase = 2
      call mtxvec(nx,ny,nz,a,b,wksp,icase)
      call l2norm(nx,ny,nz,wksp,res_AD0)
*      call l2norm(nx,ny,nz,b,res_AD0)
c
      do 8888 itAD = 1,itmARTDI
c
         call cgnr(nx,ny,nz,a,x,r,p,ap,wksp,tolCGNR,iterCGNR,itmCGNR)
         ittlCGNR = ittlCGNR + iterCGNR
c
         if(itAD.eq.1 .and. iddirac.eq.1) call correct(x)
c
         do 2000 k = 1,nz
         do 2000 j = 1,ny
         do 2000 i = 1,nx
           u(i,j,k) = u(i,j,k) + x(i,j,k)
 2000    continue
c
         icase = 1
         call mtxvec(nx,ny,nz,ao,u,wksp,icase)
         do 2200 k = 1,nz
         do 2200 j = 1,ny
         do 2200 i = 1,nx
            r(i,j,k) = b(i,j,k)-wksp(i,j,k) 
 2200    continue
c
         icase = 2
         call mtxvec(nx,ny,nz,a,r,wksp,icase)
         call l2norm(nx,ny,nz,wksp,residu)
*         call l2norm(nx,ny,nz,r,residu)
         rel_res = residu/res_AD0
         print'(/1x,"rel_res (",i4," ) =",1pe10.2
     &          /1x,"total CGNR iter =",i6)',itAD,rel_res,ittlCGNR
         write(1,455) itAD,rel_res,ittlCGNR
         if(rel_res.lt.tol) goto 4000
c
         do 2400 k = 1,nz
         do 2400 j = 1,ny
         do 2400 i = 1,nx
           x(i,j,k) = ctmp0
 2400    continue
c
 8888 continue
c
 4000 continue
c
      if(iddirac.ne.1) then
      do 4500 k = 1,nz
      do 4500 j = 1,ny
      do 4500 i = 1,nx
        wksp(i,j,k) = u(i,j,k) - truev(i,j,k)
 4500 continue
      call l8norm(nx,ny,nz,wksp,t1)
      call l8norm(nx,ny,nz,truev,t2)
      thenorm = t1/t2
      print'(1x,"relative.L8.err =",1pe10.2)', thenorm
      write(1,465) thenorm
      endif
c
 455  format(/1x,"rel_res (",i4," ) =",1pe10.2
     &       /1x,"total CGNR iter =",i6)
 465  format(1x, "relative.L8.err =",1pe10.2)
c
 9999 return
      end

c=======================================================================
      subroutine driver_save(a,x,r,p,ap,truev,u,b,wksp)
c=======================================================================
      include 'commons.h'
      complex*8 a(1),p(1),ap(1)
      complex*8 x(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 r(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 u(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 b(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 truev(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 wksp(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 ctmp0
c
      ctmp0= (0.0,0.0)
      tol5 = 5.*tol
      ittlCGNR= 0
      tolCGNR = tolCGNR1
c
      call iguess(nx,ny,nz,p)
      call iguess(nx,ny,nz,ap)
      call iguess(nx,ny,nz,x)
      call iguess(nx,ny,nz,u)
      call iguess(nx,ny,nz,b)
      call iguess(nx,ny,nz,wksp)
c
      call diagonal(a,ao)
      call rhstrue(b,truev)
      do 1000 k = 1,nz
      do 1000 j = 1,ny
      do 1000 i = 1,nx
        r(i,j,k) = b(i,j,k)
 1000 continue
      call l2norm(nx,ny,nz,b,res_AD0)
c
      do 8888 itAD = 1,itmax
c
         if(itAD.eq.2) tolCGNR=sqrt(tolCGNR1*tolCGNR2)
         if(itAD.ge.3 .and. itAD.le.5) tolCGNR=real(itAD-2)*tolCGNR2
c
         call cgnr(nx,ny,nz,a,x,r,p,ap,wksp,tolCGNR,iterCGNR,itmax)
         ittlCGNR = ittlCGNR + iterCGNR
         if(itAD.eq.1 .and. iddirac.eq.1) then
            call correct(x)
            qual_fac2 = 4.*qual_fac2
            artdamp   = artdamp/4.
            call diagonal(a,ao)
         endif
c
         do 2000 k = 1,nz
         do 2000 j = 1,ny
         do 2000 i = 1,nx
           u(i,j,k) = u(i,j,k) + x(i,j,k)
 2000    continue
c
         icase = 1
         call mtxvec(nx,ny,nz,a,u,wksp,icase)
         do 2200 k = 1,nz
         do 2200 j = 1,ny
         do 2200 i = 1,nx
           r(i,j,k) = b(i,j,k) +artdamp*u(i,j,k) -wksp(i,j,k) 
 2200    continue
c
         call l2norm(nx,ny,nz,r,residu)
         rel_res = residu/res_AD0
         print'(/1x,"rel_res (",i4," ) =",1pe10.2
     &          /1x,"total CGNR iter =",i6)',itAD,rel_res,ittlCGNR
         write(1,455) itAD,rel_res,ittlCGNR
         if(rel_res.lt.tol) then
            goto 4000
         elseif(rel_res.lt.tol5) then
            icase = 2
            call mtxvec(nx,ny,nz,a,r,wksp,icase)
            call l2norm(nx,ny,nz,wksp,residu)
            rel_res = residu/res_AD0
            if(rel_res.lt.tol) goto 4000
         endif
c
         do 2400 k = 1,nz
         do 2400 j = 1,ny
         do 2400 i = 1,nx
           x(i,j,k) = ctmp0
 2400    continue
c
 8888 continue
c
 4000 continue
c
      if(iddirac.ne.1) then
      do 4500 k = 1,nz
      do 4500 j = 1,ny
      do 4500 i = 1,nx
        wksp(i,j,k) = u(i,j,k) - truev(i,j,k)
 4500 continue
      call l8norm(nx,ny,nz,wksp,t1)
      call l8norm(nx,ny,nz,truev,t2)
      thenorm = t1/t2
      print'(1x,"rel.L8.error  =",1pe10.2)', thenorm
      write(1,465) thenorm
      endif
c
 455  format(/1x,"rel_res (",i4," ) =",1pe10.2
     &       /1x,"total CGNR iter =",i6)
 465  format(1x, "relative.L8.err =",1pe10.2)
c
 9999 return
      end

c=======================================================================
      subroutine diagonal(a,ao)
c=======================================================================
      include 'commons.h'
      complex*8 a(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 ao(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 diag,atten,bc_cont,ctmp
c
      if(nx.ne.ny .or. ny.ne.nz .or. nz.ne.nx) stop 'non-uniform'
c
      ctmp = (0.d0,0.d0)
      do 10 k = 0,nz+1
      do 10 j = 0,ny+1
      do 10 i = 0,nx+1
        a(i,j,k) = ctmp
        ao(i,j,k) = ctmp
 10   continue
         print*,"artdamp =",artdamp
c
c ................................................
c
      wave = (omega*hx)**2
      atten= im*(q*hx)**2
      diag = 6.d0+atten
      bc_cont=im*2.d0*omega*hx
c
      do 1000 k = 1, nz
          pz = hz*dble(k-1)+az
          idz= 0
          if(k.eq.1 .or. k.eq.nz) idz=1
      do 1000 j = 1, ny
          py = hy*dble(j-1)+ay
          idy= 0
          if(j.eq.1 .or. j.eq.ny) idy=1
      do 1000 i = 1, nx
          px = hx*dble(i-1)+ax
          idx= 0
          if(i.eq.1 .or. i.eq.nx) idx=1
          velocity = cc(px,py,pz)
          ao(i,j,k) = diag - wave/(velocity**2)
          if(idx.eq.1) ao(i,j,k)=ao(i,j,k)+bc_cont/velocity
          if(idy.eq.1) ao(i,j,k)=ao(i,j,k)+bc_cont/velocity
          if(idz.eq.1) ao(i,j,k)=ao(i,j,k)+bc_cont/velocity
 1000 continue
c
      do 2000 k = 1, nz
      do 2000 j = 1, ny
      do 2000 i = 1, nx
        a(i,j,k) = ao(i,j,k)+artdamp
 2000 continue
c
 9999 return
      end

