c=======================================================================
      subroutine cgnr(nx,ny,nz,a,x,r,p,ap,wksp,tolCGNR,iter,itmCGNR)
c=======================================================================
      complex*8 a(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 x(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 r(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 p(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 ap(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 wksp(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 alfa,beta,ctmp,top,bot
c
      iphase= 1
      tol2  = tolCGNR*2.d0
c
      icase = 2
      call mtxvec(nx,ny,nz,a,r,wksp,icase)
c
      do 100 k = 1,nz
      do 100 j = 1,ny
      do 100 i = 1,nx
        ctmp = wksp(i,j,k)
        r(i,j,k) = ctmp
        p(i,j,k) = ctmp
 100  continue
      call l2norm(nx,ny,nz,r,res0)
      print*
c
      do 8888 iter=1,itmCGNR
c--------------------------------------------------------
      call vecvec(nx,ny,nz,p,r,top)
      icase = 1
      call mtxvec(nx,ny,nz,a,p,ap,icase)
      call vecvec(nx,ny,nz,ap,ap,bot)
      alfa = top/bot
c
      do 1000 k = 1,nz
      do 1000 j = 1,ny
      do 1000 i = 1,nx
        x(i,j,k) = x(i,j,k) + alfa*p(i,j,k)
 1000 continue
c
      icase = 2
      call mtxvec(nx,ny,nz,a,ap,wksp,icase)
      do 1400 k = 1,nz
      do 1400 j = 1,ny
      do 1400 i = 1,nx
        r(i,j,k) = r(i,j,k) - alfa*wksp(i,j,k)
 1400 continue
c
      call l2norm(nx,ny,nz,r,res)
      residu = res/res0
      if(iter.eq.1.or.mod(iter,20).eq.0.or.residu.lt.tol2) then
       print'(5x,"residu(",i4,") = ",f9.6," /",f9.6," =",1pe9.2)'
     &      ,iter,res,res0,residu
      endif
      if(residu.lt.tolCGNR) goto 4444
c
      icase = 1
      call mtxvec(nx,ny,nz,a,r,wksp,icase)
      call vecvec(nx,ny,nz,ap,wksp,top)
      beta = -top/bot
c
      do 1600 k = 1,nz
      do 1600 j = 1,ny
      do 1600 i = 1,nx
        p(i,j,k) = r(i,j,k) + beta*p(i,j,k)
 1600 continue
c--------------------------------------------------------
 8888 continue
c
 4444 continue
      if(iter.gt.itmCGNR) iter=itmCGNR
*      print'(/5x,"iteration #   =", i6
*     &       /5x,"rel. residual =",1pe10.2)', iter,residu
c
 9999 return
      end

c=======================================================================
      subroutine vecvec(nx,ny,nz,a,b,prod)
c=======================================================================
      complex*8 a(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 b(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 prod
c
      prod =0.d0
      do 100 k = 1,nz
      do 100 j = 1,ny
      do 100 i = 1,nx
         prod = prod + conjg(a(i,j,k))*b(i,j,k)
 100  continue
c
 9999 return
      end

c=======================================================================
      subroutine mtxvec(nx,ny,nz,a,v,av,icase)
c=======================================================================
      complex*8 a(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 v(0:(nx+1),0:(ny+1),0:(nz+1))
      complex*8 av(0:(nx+1),0:(ny+1),0:(nz+1))
c
      goto(1,2) icase
 1    continue
c
      do 1000 k = 1,nz
        tz1 = -1.d0
        tz2 = -1.d0
        if(k.eq.1) then
          tz1 = 0.d0
          tz2 = -2.d0
        else if(k.eq.nz) then
          tz1 = -2.d0
          tz2 = 0.d0
        endif
      do 1200 j = 1,ny
        ty1 = -1.d0
        ty2 = -1.d0
        if(j.eq.1) then
          ty1 = 0.d0
          ty2 = -2.d0
        else if(j.eq.ny) then
          ty1 = -2.d0
          ty2 = 0.d0
        endif
      do 1400 i = 1,nx
        tx1 = -1.d0
        tx2 = -1.d0
        if(i.eq.1) then
          tx1 = 0.d0
          tx2 = -2.d0
        else if(i.eq.nx) then
          tx1 = -2.d0
          tx2 = 0.d0
        endif
        av(i,j,k) = a(i,j,k)*v(i,j,k)
     &            + tx1*v(i-1,j,k) + tx2*v(i+1,j,k)
     &            + ty1*v(i,j-1,k) + ty2*v(i,j+1,k)
     &            + tz1*v(i,j,k-1) + tz2*v(i,j,k+1)
 1400 continue
 1200 continue
 1000 continue
      goto 9999
c
 2    continue
c
      nxm1=nx-1
      nym1=ny-1
      nzm1=nz-1
c
      do 2000 k = 1,nz
        tz1 = -1.d0
        tz2 = -1.d0
        if(k.eq.1) then
          tz1 = 0.d0
        else if(k.eq.2) then
          tz1 = -2.d0
        else if(k.eq.nzm1) then
          tz2 = -2.d0
        else if(k.eq.nz) then
          tz2 = 0.d0
        endif
      do 2200 j = 1,ny
        ty1 = -1.d0
        ty2 = -1.d0
        if(j.eq.1) then
          ty1 = 0.d0
        else if(j.eq.2) then
          ty1 = -2.d0
        else if(j.eq.nym1) then
          ty2 = -2.d0
        else if(j.eq.ny) then
          ty2 = 0.d0
        endif
      do 2400 i = 1,nx
        tx1 = -1.d0
        tx2 = -1.d0
        if(i.eq.1) then
          tx1 = 0.d0
        else if(i.eq.2) then
          tx1 = -2.d0
        else if(i.eq.nxm1) then
          tx2 = -2.d0
        else if(i.eq.nx) then
          tx2 = 0.d0
        endif
        av(i,j,k) = conjg(a(i,j,k))*v(i,j,k)
     &            + tx1*v(i-1,j,k) + tx2*v(i+1,j,k)
     &            + ty1*v(i,j-1,k) + ty2*v(i,j+1,k)
     &            + tz1*v(i,j,k-1) + tz2*v(i,j,k+1)
 2400 continue
 2200 continue
 2000 continue
c
 9999 return
      end

c=======================================================================
      subroutine l2norm(nx,ny,nz,v,thenorm)
c=======================================================================
      complex*8 v(0:(nx+1),0:(ny+1),0:(nz+1))
c
      thenorm =0.d0
      do 100 k = 1,nz
      do 100 j = 1,ny
      do 100 i = 1,nx
        thenorm = thenorm + real(v(i,j,k))**2 + imag(v(i,j,k))**2
 100  continue
      thenorm = sqrt(thenorm)
c
 9999 return
      end

c=======================================================================
      subroutine l8norm(nx,ny,nz,v,thenorm)
c=======================================================================
      complex*8 v(0:(nx+1),0:(ny+1),0:(nz+1))
c
      thenorm =0.d0
      do 100 k = 1,nz
      do 100 j = 1,ny
      do 100 i = 1,nx
        temp = cabs(v(i,j,k))
        if(temp.gt.thenorm) thenorm=temp
 100  continue
c
 9999 return
      end

