      program main
c
      parameter( mnx=81, mny=mnx, mnz=mnx )
c
      include 'commons.h'
      parameter( narray = (mnx+2)*(mny+2)*(mnz+2) )
      complex*8 a(narray),ao(narray),x(narray),r(narray)
      complex*8 p(narray),ap(narray),wksp(narray)
      complex*8 u(narray),b(narray)
      complex*8 truev(narray)
      real tarray(2)
c
      time  = etime (tarray)
      tbegin= tarray(1)
c
      im  = (0.0d0,1.0d0)
      pi  = 4.0d0*datan(1.0d0)
      zero= 0.0d0
      half= 0.5d0
      one = 1.0d0
      two = 2.0d0
      four= 4.0d0
c
      call readata(mnx,mny,mnz)
c
      call c_average
      print'(" averge of c  = ",f10.3)',c_zero
c
      if(qual_fac.le.0.0) then
         q=0.0
      else
         q=omega/(c_zero*sqrt(qual_fac))
      endif
      print'(" q (phys.damp)= ",f10.3)',q
c
      if(idautodamp.eq.1) then
         sigma = sqrt(omega/(c_zero*hx))/8.
      else
         if(qual_fac2.le.0.0) then
            sigma=0.0
         else
            sigma=omega/(c_zero*sqrt(qual_fac2))
         endif
      endif
c
      print'(" sigma (damp) = ",f10.3)',sigma
      artdamp = im*(sigma*hx)**2
c
c .....................................................
c
      call driver(a,ao,x,r,p,ap,truev,u,b,wksp)
c
      time  = etime (tarray)
      tend= tarray(1)
      com_time = tend-tbegin
      print'(1x,"all.comput.time =",f9.1/)',com_time
      write(1,465) com_time
c
      if(level.ge.3) then
        call print_x(nx,ny,nz,x)
      endif
c
 465  format(/1x, "all.comput.time =",f9.1)
c
      stop
      end

c=======================================================================
      subroutine readata(mnx,mny,mnz)
c=======================================================================
      include 'commons.h'
c
      read (5,*) nx
        ny=nx
        nz=nx
        if(nx.gt.mnx) stop 'problem: too big'
        write(6,442) nx,ny,nz
c
      read*
      read (5,*) freq
      read (5,*) qual_fac
      read (5,*) qual_fac2
      read (5,*) idautodamp
      read (5,*) ncc
      read (5,*) tol
      read (5,*) tolCGNR
      read (5,*) itmax
        omega=2.0d0*pi*freq
        write(6,446) freq,omega,qual_fac,qual_fac2
        write(6,460) sigma
c
      read*
      read (5,*) level
      read (5,*) npcol
      read (5,*) inorm
      read (5,*) iddirac
      read (5,*) srcmag
c
        ax = 0.0d0
        bx = 1.0d0
        ay = 0.0d0
        by = 1.0d0
        az = 0.0d0
        bz = 1.0d0
      read*
      read (5,*) idchdmn
        if(idchdmn.eq.0) then
          print'(1x,"the domain   =   the unit cube.")'
          goto 3000
        endif
      read (5,*) ax
      read (5,*) bx
      read (5,*) ay
      read (5,*) by
      read (5,*) az
      read (5,*) bz
        print'(1x,"the domain   = ",$)'
        write(6,450) ax,bx,ay,by,az,bz
c
 3000 continue
c
      hx   = (bx-ax)/dble(nx-1)
      hy   = (by-ay)/dble(ny-1)
      hz   = (bz-az)/dble(nz-1)
      neqn = (nx+2)*(ny+2)*(nz+2)
      mx   = nx
      my   = ny
      mz   = nz
c
      write(6,447) tol
      write(6,448) level,itmax
      write(6,449) ncc
c
 442  format(/1x,'nx X ny X nz = ',i6,'  X',i5,'  X',i5)
 446  format( 1x,'freq,om,Q1&2 = ',4(f10.3))
 460  format( 1x,'sigma        = ',f10.3)
 447  format( 1x,'tolerance    = ',1pe15.7)
 448  format( 1x,'level,itmax  = ',2i6)
 449  format( 1x,'coef_type    = ',i6)
 450  format( 2x,'(',f5.2,',',f5.2,' ) X (',f5.2,',',f5.2,
     &      ' ) X (',f5.2,',',f5.2,' )')
c
 9999 return
      end

c=======================================================================
      subroutine print_x(nx,ny,nz,x)
c=======================================================================
      complex*8 x(0:(nx+1),0:(ny+1),0:(nz+1))
c
      jump=1
      if(nx.gt.70) jump=2
c
      iout1=11
      iout2=12
      j=ny/4+1
      do 1000 k = 1,nz,jump
         write(iout1,450) (real(x(i,j,k)),i=1,nx,jump)
         write(iout2,450) (imag(x(i,j,k)),i=1,nx,jump)
 1000 continue
c
      iout1=21
      iout2=22
      j=ny/2+1
      do 2000 k = 1,nz,jump
         write(iout1,450) (real(x(i,j,k)),i=1,nx,jump)
         write(iout2,450) (imag(x(i,j,k)),i=1,nx,jump)
 2000 continue
c
      iout1=31
      iout2=32
      j=ny-ny/4
      do 3000 k = 1,nz,jump
         write(iout1,450) (real(x(i,j,k)),i=1,nx,jump)
         write(iout2,450) (imag(x(i,j,k)),i=1,nx,jump)
 3000 continue
c
 450  format(6f12.7)
c
 9999 return
      end

