      subroutine thstifb(xl,nben,dsh,sx,det,elstif,r,
     &                   ibnod,id,ien,fsh,
     &                   nel,nn,nen,nint,nee,iout,level)
c
c 3-D Tetrahedra
c program to form stiffness matrix for a boundary element.
c 
c  dsh(j,i,1) = (J^{-1})(i,j),  i,j = 1,2,3
c
      dimension xl(3,1),nben(1),dsh(4,1),fsh(3,1)
      dimension ibnod(1),id(1,1),ien(nen,1)
      dimension elstif(nee,1),r(1),cpde(10),cbc(4)
      dimension sx(3,1)
c
      dimension xint(3),vn(3),n(3)
c
c.... initialize element matrix and right hand side
c
      do 100 i=1,nee
         r(i) = 0.
         do 100 j=1,nee
            elstif(i,j) = 0.
 100  continue
c
      do 999 k=1,nn
c
c.... determine the evaluation points and the normal vectors
c     for each faces
c
      nbenk = nben(k)
      if( nbenk.eq.1 ) then
          n(1) = 2
          n(2) = 3
          n(3) = 4
      elseif( nbenk.eq.2 ) then
          n(1) = 1
          n(2) = 3
          n(3) = 4
      elseif( nbenk.eq.3 ) then
          n(1) = 1
          n(2) = 2
          n(3) = 4
      else
          n(1) = 1
          n(2) = 2
          n(3) = 3
           a12 = xl(1,2)-xl(1,1)
           a22 = xl(2,2)-xl(2,1)
           a32 = xl(3,2)-xl(3,1)
           a13 = xl(1,3)-xl(1,1)
           a23 = xl(2,3)-xl(2,1)
           a33 = xl(3,3)-xl(3,1)
          vn(1)= (a22*a33-a32*a23) / det
          vn(2)= (a32*a13-a12*a33) / det
          vn(3)= (a12*a23-a22*a13) / det
      endif
c
      if(nbenk.eq.4) goto 215
      do 210 i = 1,3
          vn(i) = -sx(nbenk,i)
 210  continue
c
 215  vleng = sqrt(vn(1)**2+vn(2)**2+vn(3)**2)
c
      do 220 i = 1,3
          vn(i) = vn(i) / vleng
 220  continue
c
      area  = 0.5 * vleng * abs(det)
      temp  = area / 3.0
c
c.... determine i0side
c
      cxx = (xl(1,n(1))+xl(1,n(2))+xl(1,n(3)))/3.
      cyy = (xl(2,n(1))+xl(2,n(2))+xl(2,n(3)))/3.
      czz = (xl(3,n(1))+xl(3,n(2))+xl(3,n(3)))/3.
c
      i0side = 0
c
      ibnod1 = ibnod(ien(n(1),nel))
      ibnod2 = ibnod(ien(n(2),nel))
      ibnod3 = ibnod(ien(n(3),nel))
      if(ibnod1.eq.ibnod2 .and. ibnod1.eq.ibnod3) then
         i0side = ibnod1
      else
          call q1bdry(cxx,cyy,czz,i0side)
      endif
c
      if(i0side .eq. 0 ) then
        write(iout,*) "*** from thstifb.f ***"
        write(iout,*) "Warning: Wrong boundary side assignment."
        return
      endif
c
c.... determine scale factors
c
      call q1pcoe(cxx,cyy,czz,cpde)
      call q1bcoe(i0side,cxx,cyy,czz,cbc)
      if(cbc(2).ne.0.0) then
           alpha = vn(1)*cpde(1)/cbc(2)
      elseif(cbc(3).ne.0.0) then
           alpha = vn(2)*cpde(3)/cbc(3)
      elseif(cbc(4).ne.0.0) then
           alpha = vn(3)*cpde(7)/cbc(4)
      else
           write(iout,*) "*** from thstifb.f ***"
           write(iout,*) "Warning: Wrong boundary condition assigned."
           return
      endif
      scale = -temp * alpha
c
c.... calculate the stiffness matrix for each face
c
      do 444 l = 1, 3
c
      do 340 i = 1, 3
      xint(i)= fsh(1,l)*xl(i,n(1))+fsh(2,l)*xl(i,n(2))
     &        +fsh(3,l)*xl(i,n(3))
 340  continue
c
      call q1bcoe(i0side,xint(1),xint(2),xint(3),cbc)
      brhs = r1brhs(i0side,xint(1),xint(2),xint(3))
c
      do 444 i= 1,3
        r(n(i)) = r(n(i)) + brhs*fsh(i,l)*scale
        do 444 j= 1,3
         elstif(n(i),n(j))= elstif(n(i),n(j))
     &                    + cbc(1)*fsh(i,l)*fsh(j,l)*scale
 444  continue
c
 999  continue

      return
      end
