      subroutine thdstif(xl,w,det,sx,shf,dsh,elstif,r,
     &                nen,nint,nee,iout,level)
c
c  3-D Tetrahedra
c
c program to form stiffness matrix for a continuum element with "nen" 
c nodes
c
      dimension xl(3,1),w(1),shf(4,1)
      dimension elstif(nee,1),r(1),cpde(10)
      dimension sx(3,1),dsh(4,1)
      dimension xint(3)
c
c.... form "dsh"
c
      do 50 i=1,3
          dsh(1,i)=sx(1,i)
          dsh(2,i)=sx(2,i)
          dsh(3,i)=sx(3,i)
          dsh(4,i)=-(sx(1,i)+sx(2,i)+sx(3,i))
 50   continue

c
c.... initialize element matrix and right hand side
c
      do 100 i=1,nee
         r(i) = 0.
         do 100 j=1,nee
            elstif(i,j) = 0.
 100  continue
c
      volume = abs(det)/6.0
c
c.... loop on integration points
c
      do 333 l=1,nint
c
      temp = w(l)*volume
c
c.... set up the fem element matrix
c     compute the global coordinates of integration points
c
      do 110 i = 1, 3
      xint(i)= shf(1,l)*xl(i,1)+shf(2,l)*xl(i,2)
     &        +shf(3,l)*xl(i,3)+shf(4,l)*xl(i,4)
 110  continue
c
c.... compute the pde coefficients and right hand side
c
      call q1pcoe(xint(1),xint(2),xint(3), cpde)
      pderhs= r1prhs(xint(1),xint(2),xint(3))
c
      do 120 i= 1,nee
         r(i) = r(i) + pderhs*shf(i,l)*temp
         do 120 j= 1,nee
            gsum = - cpde(1)*dsh(i,1)*dsh(j,1)
     &             - cpde(3)*dsh(i,2)*dsh(j,2)
     &             - cpde(7)*dsh(i,3)*dsh(j,3)
     &             + shf(i,l)*( cpde(4)*dsh(j,1)+cpde(5)*dsh(j,2)
     &                        +cpde(10)*dsh(j,3)+cpde(6)*shf(j,l))
            elstif(i,j)= elstif(i,j) + gsum*temp
  120 continue
c
  333 continue
c
c.... print the results
c
      if( level .lt. 7 ) return
c
      write(iout,*)
      write(iout,*) '*** From thdck.f : elstif and r = '
      do 200 i=1,nee
         print'(4(f13.7),4x,f13.7)',(elstif(i,j),j=1,nee),r(i)
         write(iout,*)
 200  continue
c
      return
      end
c_______________________________________________________________________
