      subroutine thdjaco(xl,det,xs,sx,iout)
c ----------------------------------------------------------
c.... program to calculate the jacobian determinant 
c     and inverse jacobi matrix 
c
c        xl(j,i) = global coordinates
c        det     = jacobian determinant
c        xs(i,j) = jacobian matrix
c        sx(i,j) = inverse jacobian matrix
 
      dimension xl(3,1)
      dimension xs(3,1),sx(3,1)
c
      do 100 j=1,3
      do 100 i=1,3
         xs(i,j) = xl(i,j) - xl(i,4)
  100 continue
c
      tmp11 = xs(2,2)*xs(3,3)-xs(2,3)*xs(3,2)
      tmp21 = xs(2,3)*xs(3,1)-xs(2,1)*xs(3,3)
      tmp31 = xs(2,1)*xs(3,2)-xs(2,2)*xs(3,1)
c
      det   = xs(1,1)*tmp11 + xs(1,2)*tmp21 + xs(1,3)*tmp31
c
      if (det.eq.0.0) then
        print*
        print*,'***From thdjaco.f***'
     &        ,'zero determinant in nel=',nel,'   in iout=',iout
        stop
      endif
c
c ... set J^(-1)
c
      sx(1,1) = tmp11 / det
      sx(2,1) = tmp21 / det
      sx(3,1) = tmp31 / det
      sx(1,2) = ( xs(1,3)*xs(3,2)-xs(1,2)*xs(3,3) ) / det
      sx(2,2) = ( xs(1,1)*xs(3,3)-xs(1,3)*xs(3,1) ) / det
      sx(3,2) = ( xs(1,2)*xs(3,1)-xs(1,1)*xs(3,2) ) / det
      sx(1,3) = ( xs(1,2)*xs(2,3)-xs(1,3)*xs(2,2) ) / det
      sx(2,3) = ( xs(1,3)*xs(2,1)-xs(1,1)*xs(2,3) ) / det
      sx(3,3) = ( xs(1,1)*xs(2,2)-xs(1,2)*xs(2,1) ) / det
c
      return
      end
