      subroutine thdcshf(shf,shfb,w,nint,level,i1outp)

c  3-D Tetrahedra
c
c.... program to calculate integration-rule weights, shape functions
c     and local derivatives for a four-node tetrahedral element
c
c        shf(i,l) = local  shape function
c              w(l) = integration-rule weight
c                 i = local node number
c                 l = integration point number
c....          nint = number of integration points
 
      dimension shf(4,1),shfb(3,1),w(1)
c
c.................................................................
c
      if(nint.eq.1)then
          w(1) = 1.0
          do 50 i=1,4
             shf(i,1) = 0.250
  50      continue
c
      elseif(nint.eq.4)then
          alpha = (5.-sqrt(5.))/20.
          beta  = (5.+3.*sqrt(5.))/20.
          do 300 l=1,nint
             w(l) = 0.250
             do 350 i=1,4
                shf(i,l) = alpha
  350        continue
             shf(l,l) = beta
  300     continue
c
      else
          if(nint.ne.5)then
             print*
             print*, " ** from thdcshf.f **"
             print'("Warning: ''nint'' was changed from ",
     &                i2," to 5."/)',nint
             nint = 5
          endif
c
          w(nint) = -0.8
          do 100 i=1,4
             shf(i,nint) = 0.250
  100     continue
          do 150 l=1,nint-1
             w(l) = 0.45
             do 200 i=1,4
                shf(i,l) = 1.0/6.0
  200        continue
             shf(l,l) = 0.50
  150     continue
c
      endif
c
c.... for boundary integration
c
      do 400 j = 1,3
         do 420 i = 1,3
           shfb(i,j) = 1./6.
 420     continue
         shfb(j,j) = 2./3.
 400  continue
c
c.................................................................
c
      return
      end
