      subroutine solve(mneq,neqn,ncoe,idco,coef,x,A)
c
c A(mneq,nb)
c Input : x= rhs
c Output: x= solution
c
      dimension idco(mneq,1),coef(mneq,1),A(mneq,1)
c
c.... Calculate half bandwidth
c
      nh= 0
      do 110 i=1,neqn
      do 110 j=1,ncoe
	  ii= idco(i,j) -i +1
	  if( ii .gt. nh ) nh= ii
 110  continue
c 
c.... Calculate half bandwidth
c
      nb= 2*nh+1
c
c.... Store coef in A
c
      do 120 i=1,neqn
         do 130 j=1,nb
	     A(i,j)= real(0) 
 130     continue
         do 120 j=1,ncoe
	     ii= idco(i,j) -i +nh 
	     if( ii .gt. 0 ) A(i,ii)= coef(i,j)
 120  continue
c
c.... print A 
c
c     print*
c     print*,'*** From solve.f ****'
c     print*,'nb=',nb
c     print*,'matrix A='
c     do 131 i=1,neqn
c        print'(20f8.3)', (A(i,j),j=i,nb)
c131  continue
c
c
c.... Solve
c
      call lufac(mneq,neqn,nh,A)
      call subst(mneq,neqn,nh,A,x)
c
      end
c______________________________________________________________________

      subroutine lufac(mn,nn,nh,A)
c
c This routine L-U factorizes band matrix without pivoting.
c A(i,nh) is the diagonal entry in i-th row of the matrix.
c band width "nb" is odd number.
c nh= half of band width
c
      dimension  A(mn,1)
c
      nb= 2*nh+1
c
      do 120 i=1,nn-1
         do 120 k=1,min(nh-1,nn-i)
	    A(i+k,nh-k)= A(i+k,nh-k)/ A(i,nh)
            do 120 j=nh+1,min(nb,nh+nn-i)
	       A(i+k,j-k)= A(i+k,j-k) - A(i,j)*A(i+k,nh-k)
 120  continue    
c
      end
c_______________________________________________________________________
c
      subroutine subst(mn,nn,nh,A,x)
c
c Input: L-U fatorized info are stored in A.
c        x= rhs
c Output:x= solution
c
      dimension  A(mn,1),x(1)
c
c.... forward substitution
c
      nb= 2*nh+1
c
      do 120 i=2,nn
         do 120 j=max(1,nh-i+1),nh-1
	    x(i)= x(i) -x(i-nh+j)*A(i,j)
 120  continue    
c
c.... backward substitution
c
      do 130 i=nn,1,-1
         do 140 j=nh+1,min(nb,nh+nn-i)
	      x(i)= x(i) -x(i-nh+j)*A(i,j)
 140     continue    
	 x(i)= x(i)/A(i,nh)
 130  continue    
c
      end
c_______________________________________________________________________
