      real function r3eval(ideriv,hhh,xx,yy,zz)
c--------------------------------------------------------------
c ... evaluate the values "U, Ux, Uy, Uz" for the given point.
c     xs(i,j) : the Jacobian matrix
c     sxij    : the inverse Jacobian matrix
c     here the main strategies are using the number "hhh" and
c     finding the barycentric ccordinates.
c
      common / c1mhnu / ndim,nen,numel,numnp
      common / c1ivdi / i1neqn, i1mneq, i1ncoe, i1mnco
      common / c1mhxy / x(3,1)
      common / c1mien / ien(4,1)
      common / c3fmtb / tabl(1)
      dimension xs(3,3)

      do 9999 nel=1,numel

      rhx = xx-x(1,ien(4,nel))
      if(abs(rhx) .gt. hhh) goto 9999
      rhy = yy-x(2,ien(4,nel))
      if(abs(rhy) .gt. hhh) goto 9999
      rhz = zz-x(3,ien(4,nel))
      if(abs(rhz) .gt. hhh) goto 9999
c
      nel44      = ien(4,nel)
      do 120 i=1, 3
         nelii   = ien(i,nel)
         xs(1,i) = x(1,nelii) - x(1,nel44)
         xs(2,i) = x(2,nelii) - x(2,nel44)
         xs(3,i) = x(3,nelii) - x(3,nel44)
 120  continue
c
c ... set J0 = det*J^{-1} and determinant
c
      sx11 = xs(2,2)*xs(3,3)-xs(2,3)*xs(3,2)
      sx12 = xs(1,3)*xs(3,2)-xs(1,2)*xs(3,3)
      sx13 = xs(1,2)*xs(2,3)-xs(1,3)*xs(2,2)
      det  = xs(1,1)*sx11 + xs(2,1)*sx12 + xs(3,1)*sx13
      alpha=sx11*rhx+sx12*rhy+sx13*rhz
      alpha= alpha/det
      if(alpha .lt. 0.0 .or. alpha .gt. 1.0 ) goto 9999
c
      sx21 = xs(2,3)*xs(3,1)-xs(2,1)*xs(3,3)
      sx22 = xs(1,1)*xs(3,3)-xs(1,3)*xs(3,1)
      sx23 = xs(1,3)*xs(2,1)-xs(1,1)*xs(2,3)
      beta = sx21*rhx + sx22*rhy + sx23*rhz
      beta = beta/det
      if( beta .lt. 0.0 .or.  beta .gt. 1.0 ) goto 9999
c
      sx31 = xs(2,1)*xs(3,2)-xs(2,2)*xs(3,1)
      sx32 = xs(1,2)*xs(3,1)-xs(1,1)*xs(3,2)
      sx33 = xs(1,1)*xs(2,2)-xs(1,2)*xs(2,1)
      gamma= sx31*rhx + sx32*rhy + sx33*rhz
      gamma= gamma/det
      if(gamma .lt. 0.0 .or. gamma .gt. 1.0 ) goto 9999
c
      eta = alpha + beta + gamma
      if(eta .gt. 1.0 ) goto 9999
c
      if(ideriv.eq.6)then
         eta    = 1.0 - eta
         r3eval = tabl(ien(1,nel))*alpha + tabl(ien(2,nel))*beta
     &          + tabl(ien(3,nel))*gamma + tabl(ien(4,nel))*eta
                             return
      elseif(ideriv.eq.4)then
         tttt   = tabl(ien(4,nel))
         r3eval = sx11*(tabl(ien(1,nel))-tttt)
     &          + sx21*(tabl(ien(2,nel))-tttt)
     &          + sx31*(tabl(ien(3,nel))-tttt)
         r3eval = r3eval/det
                             return
      elseif(ideriv.eq.5)then
         tttt   = tabl(ien(4,nel))
         r3eval = sx12*(tabl(ien(1,nel))-tttt)
     &          + sx22*(tabl(ien(2,nel))-tttt)
     &          + sx32*(tabl(ien(3,nel))-tttt)
         r3eval = r3eval/det
                             return
      elseif(ideriv.eq.10)then
         tttt   = tabl(ien(4,nel))
         r3eval = sx13*(tabl(ien(1,nel))-tttt)
     &          + sx23*(tabl(ien(2,nel))-tttt)
     &          + sx33*(tabl(ien(3,nel))-tttt)
         r3eval = r3eval/det
                             return
      else
         print*, "  ** from r3eval.f **"
         print*, "Uxx,Uyy,Uzz,Uxy,Uyz,Uzx: Not yet be evaluable."
         stop
      endif
c
 9999 continue
c
      print'(" WARNING: (",f10.5,",",f10.5,",",f10.5,") ",
     &       "is not in the domain.")',xx,yy,zz
      return
      end

