      subroutine q1rfem3d(filename,x,ndim,i1bnod,ien,iben
     &                nen,numel,numnp,level,i1outp )
c
c     read data for tetrahedral elements
c     
      character*80 filename
      dimension x(ndim,1)
      integer i1bnod(1),ien(4,1),iben(4,1)

c
c  read mesh data
c
      open ( unit=9, file=filename )
      i1inp = 9

      read(i1inp,*) numnp

      do 10 i = 1, numnp
	 read(i1inp,*) x(1,i), x(2,i), x(3,i)
   10 continue

      read(i1inp,*) numel

      do 20 i = 1, numel
	 read(i1inp,*) (ien(j,i),j=1,nen),(iben(j,i),j=1,nen)
   20 continue

      read(i1inp,*) ( i1bnod(i), i=1, numnp )
c  ------------------------------------------------------------------   
c  print mesh data
c 
      if (level.lt.4) return   
c
      write(i1outp,*) 'no. of nodes=',numnp,'    no. of elements=',numel
c
      write(i1outp,*) 'element incidences'
c
      do 1001 in=1,numel
         write(i1outp,333) ien(1,in),ien(2,in),ien(3,in),ien(4,in)
333      format(4(i5))
 1001 continue
c
      write(i1outp,*) ''
      write(i1outp,*) 'node coordinates'
      do 2001 inod = 1, numnp
         write(i1outp,334) x(1,inod),x(2,inod),x(3,inod)
334      format(3(f4.0))
 2001 continue

c
      write(i1outp,*) 'type of boundary cond.'
      write(i1outp,335) (i1bnod(inod),inod = 1,numnp)
335   format(10(i5))
c
      write(i1outp,*) 'pointer vector of i1adep : i1adepp'
      write(i1outp,336)  ( i1adepp(i), i=1, numnp+1 )
      write(i1outp,*) 'element connectivity vector of nodes'
      do 40 n=1,numnp
	 write(6,338) n, i1adepp(n+1)-i1adepp(n)
         write(i1outp,337) ( i1adep(i), i=i1adepp(n), i1adepp(n+1)-1 )
   40 continue
 336  format(10i5)
 337  format(20i4)
 338  format('node #',i4,' = ',i4)
c
      close ( unit=9 )

      return
      end
c_______________________________________________________________________
