      subroutine p1c0qb(nint, ndof, nen, ndim, numnp, numel,
     &                  x, ien, iben, ibnod,id, iid, tabl,
     &                 neqn, mneq, ncoe, mnco,
     &                 coef, idco, rhs,iout,level)
c
c  3-D Tetrahedra
c
c uses direct stiffness procedure to add the element stiffness matrices
c and loads to proper locations in assemblage stiffness 
c     
c mesh and boundary condition data structures
c     ien(j,nel)= global node number for local node j of nel element
c     x(i,j) = coordinate of j-th node in the i-th direction
c
c boundary condition values
c  tabl(1,j)= value of Dirichlet boundary condition at jth boundary node
c  id(1,inod)= id : renumbering for the active nodes
c  iid(1,id)= inod  : inverse mapping of id
c  neqn= number of active nodes

      dimension x(ndim,1), ien(nen,1),iben(nen,1)
      dimension coef(mneq,1),idco(mneq,1),rhs(mneq),tabl(ndof,1)
      dimension id(ndof,1),ibnod(1),iid(ndof,1)
      dimension r1jaco(3,3),r1jabi(3,3)
c     
c local variables
c     
      dimension stif(4,4),rs(4),xl(3,4)
      dimension thdw(5),shf(4,6),shfb(3,3),dsh(4,3)
      dimension stifb(4,4),rsb(4),nben(4)
c
c.... element parameters
c
       nee = 4
c
c.... initialize lhs and rhs of matrix .
c
      ncoe= 0
c
      do 100 i = 1,neqn
         rhs(i) = 0.
         do 100 j = 1,mnco
            coef(i,j) = 0.
            idco(i,j) = 0
 100  continue
c     
c.... form equations
c     
c.... compute shape functions and its derivatives at integration points
c     and quadrature weights
c
      call thdcshf(shf,shfb,thdw,nint,level,iout)
c.................................................................
c
      do 9999 nel = 1,numel
c
c.... compute element stiffness matrix and right side
c     
      do 130 i=1,4
         xl(1,i) = x(1,ien(i,nel))
         xl(2,i) = x(2,ien(i,nel))
         xl(3,i) = x(3,ien(i,nel))
 130  continue
c
      nvtx= nen
c
c.... get Jacobian determinants and inverse matrix
c
      call thdjaco(xl,thddet,r1jaco,r1jabi,iout)
c
c.... determine element equations
c
      call thdstif(xl,thdw,thddet,r1jabi,shf,dsh,stif,rs,
     &          nen,nint,nee,iout,level)
c
c......... BOUNDARY ELEMENTS ....................................
c
c.... compute element stiffness matrix and right side
c     for mixed(Neumann) boundary conditions.
c    
      nn= 0
      do 320 i=1,nvtx
         if(iben(i,nel).ne.0) goto 320
         do 340 j = 1,nvtx
            if(j.eq.i) goto 340
            if(id(1,ien(j,nel)).ne.0 ) then
                nn= nn+1
                nben(nn) = i
                goto 320
            endif
 340     continue
 320  continue
c
      if(nn.eq.0) goto 3333
      call thstifb(xl,nben,dsh,r1jabi,thddet,stifb,rsb,
     &             ibnod,id,ien,shfb,
     &             nel,nn,nen,nint,nee,iout,level)
c
      do 360 i=1,nvtx
         rs(i)= rs(i) + rsb(i)
         do 360 j=1,nvtx
            stif(i,j)= stif(i,j) + stifb(i,j)
 360  continue
c................................................................
c.... form the arrays coef and idco
 3333 continue
c
      do 420 i=1,nvtx
            idrow = id(1,ien(i,nel))
            if( (idrow .le. 0) .or. ( idrow .gt. neqn ) ) goto 420
            rhs(idrow) = rhs(idrow) + rs(i)
c
      do 440 j=1,nvtx
            idcol= id(1,ien(j,nel))
c
            if(idcol .ne. 0 )then
                do 460 k = 1, mnco
                    idtemp = idco(idrow,k)
                    if(idtemp .eq. idcol)then
                        coef(idrow,k)=coef(idrow,k)+stif(i,j)
                        goto 440
                    elseif(idtemp .eq. 0)then
                        idco(idrow,k)=idcol
                        coef(idrow,k)=stif(i,j)
                        if( k .gt. ncoe ) ncoe= k
                        goto 440
                    endif
 460            continue
c
            else
                rhs(idrow)= rhs(idrow)-tabl(1,ien(j,nel))*stif(i,j)
            endif
 440  continue
 420  continue
c
 9999 continue
c.................................................................
c.... Print the results
c
      if( level .lt. 5) return
      write(iout,*)
      write(iout,*) '****FROM p1c0qb.f******'
      write(iout,*) 'nen=',nen,'   ndim=',ndim,'   ndof=',ndof
      write(iout,*) 'numnp=',numnp,'   numel=',numel, '   nee=',nee
      write(iout,*) 'neqn=',neqn,'  ncoe=',ncoe,'   level=',level
      write(iout,*)
      write(iout,*) 'Coef and idcoef '
      write(iout,*)
      write(iout,*) 'row= geometric_index'
      write(iout,*) '    geometric_index= coef'
      write(iout,*)
      do 210 i = 1,neqn
      write(iout,*)
      write(iout,*) 'row=', iid(1,i)
      write(iout,*) '   ',(iid(1,idco(i,j)),'=',coef(i,j),' ', j=1,ncoe)
 210  continue
      write(iout,*)
      write(iout,*) 'Right Hand_Side '
      write(iout,*)
      write(iout,*) '    geometric_index= rhs'
      write(iout,*)
      write(iout,*) '   ',(iid(1,i),'=',rhs(i),' ', i=1, neqn)
c
      end
c_______________________________________________________________________
