      subroutine mesh(ngridx,ngridy,ngridz,
     &                x,ibnod,ien,iben,ndim,nen,numel,numnp,
     &                iout,level)
c
c.... generates data for rectangular regions
c     
      common / c1regn / reg(1)
      common / c2edge / hhh
      dimension x(ndim,1),ibnod(1),ien(nen,1),iben(nen,1)
c     
c.... number nodes
c     
      hx = (reg(2)-reg(1))/float(ngridx-1)
      hy = (reg(4)-reg(3))/float(ngridy-1)
      hz = (reg(6)-reg(5))/float(ngridz-1)

      hhh = hx
      if(hy .gt. hhh) hhh=hy
      if(hz .gt. hhh) hhh=hz
      hhh = hhh*sqrt(3.)

      nod = 0
      do 100 iz = 0, ngridz-1
           azhz = az + hz*float(iz)
      do 100 iy = 0, ngridy-1
           ayhy = ay + hy*float(iy)
      do 100 ix = 0, ngridx-1
            nod = nod + 1
            x(1,nod) = ax + hx*float(ix)
            x(2,nod) = ayhy
            x(3,nod) = azhz
 100  continue
      numnp = nod
c
c.... number boundary pieces
c.... set ibnod
c
      do 120 nod = 1,numnp
	 call q1bdry(x(1,nod),x(2,nod),x(3,nod),ibnod(nod))
 120  continue
c
c.... initialize iben
c
      numel = 6*(ngridx-1)*(ngridy-1)*(ngridz-1)
      do 130 j = 1,numel
      do 130 i = 1,nen
         iben(i,j) = 1
 130  continue
c     
c.... determine element incidences
c     : give node# to each vertex of every element
c
      nngdxy = ngridx*ngridy
      nel = 0
      do 140 iz = 1,ngridz-1
          inxyz = nngdxy*(iz-1)
      do 140 iy = 1,ngridy-1
          nnxyz = inxyz + ngridx*(iy-1)
      do 140 ix = 1,ngridx-1

            nn1 = ix + nnxyz
            nn2 = nn1 + 1
            nn3 = nn1 + ngridx
            nn4 = nn3 + 1
            nn5 = nn1 + nngdxy
            nn6 = nn5 + 1
            nn7 = nn5 + ngridx
            nn8 = nn7 + 1

          nel = nel + 1
            ien(1,nel) = nn1
            ien(2,nel) = nn3
            ien(3,nel) = nn2
            ien(4,nel) = nn5
            if(iy.eq.1) iben(2,nel) = 0
            if(ix.eq.1) iben(3,nel) = 0
            if(iz.eq.1) iben(4,nel) = 0

          nel = nel + 1
            ien(1,nel) = nn2
            ien(2,nel) = nn3
            ien(3,nel) = nn6
            ien(4,nel) = nn5
            if(iy.eq.1) iben(2,nel) = 0

          nel = nel + 1
            ien(1,nel) = nn6
            ien(2,nel) = nn3
            ien(3,nel) = nn7
            ien(4,nel) = nn5
            if(ix.eq.1) iben(1,nel) = 0
            if(iz.eq.(ngridz-1)) iben(2,nel) = 0

          nel = nel + 1
            ien(1,nel) = nn6
            ien(2,nel) = nn8
            ien(3,nel) = nn7
            ien(4,nel) = nn4
            if(iy.eq.(ngridy-1)) iben(1,nel) = 0
            if(ix.eq.(ngridx-1)) iben(3,nel) = 0
            if(iz.eq.(ngridz-1)) iben(4,nel) = 0

          nel = nel + 1
            ien(1,nel) = nn2
            ien(2,nel) = nn6
            ien(3,nel) = nn3
            ien(4,nel) = nn4
            if(iz.eq.1) iben(2,nel) = 0
            if(ix.eq.(ngridx-1)) iben(3,nel) = 0

          nel = nel + 1
            ien(1,nel) = nn3
            ien(2,nel) = nn6
            ien(3,nel) = nn7
            ien(4,nel) = nn4
            if(iy.eq.(ngridy-1)) iben(2,nel) = 0

 140  continue
c     
*      numel = nel
c     
c....  print the results
c
*      do 123 i = 1, numnp
*      print'(3(e15.7))',(x(j,i),j=1,3)
* 123  continue
c
      if (level.lt.4) return   
c
      write(iout,*)
      write(iout,*) '**** From mesh.f ******'
      write(iout,*)
      write(iout,*) 'numnp=',numnp,'  numel=',numel
      write(iout,*)
      write(iout,*) 'nel= ien'
      write(iout,*) (i,'=',(ien(j,i),j=1,nen),'   ',i=1,numel)
      write(iout,*)
      write(iout,*) 'inod= x'
      write(iout,*) (i,'=',(x(j,i),j=1,ndim),'   ',i=1,numnp)
      write(iout,*)
      write(iout,*) 'inod= ibnod'
      write(iout,*) (i,'=',ibnod(i),'   ',i=1,numnp)
c
      end
c_______________________________________________________________________
