c     progrma main
c
      parameter( nnn= 9 )
      parameter( ndimm=3, nxx=nnn,nyy=nnn,nzz=nnn )
c
      parameter( mxnumnp= nxx*nyy*nzz, mnco= 30 )
      parameter( mxnumel= 6*(nxx-1)*(nyy-1)*(nzz-1) )
      parameter( mneq   = mxnumnp )
c      
c... this program generates the finite element eqautions for
c    a second order elliptic pde     
c                 -(p*ux)x - (p*uy)y - (p*uz)z + s*u = f
c INPUT:
c    mesh interface,
c    integration pts( nint = 1,4,5 or 6)
c    number of dofs per node( ndof=ned=1)
c    number of element nodes( nen=4)
c    number of element equations(nee=4)
c OUTPUT:
c    boundary condition data(id,iid,a,i1neqn)
c    fem equations(lhs: i1coef, i1idco ,rhs:r1bbbb)
c
c ========  domain processor interface =======

      common / c1mhnu / ndim,nen,numel,numnp
      common / c1mhxy / x(3,mxnumnp)
      common / c1mien / ien(4,mxnumel)
      common / c1mben / iben(4,mxnumel)
      common / c1bnod / ibnod(mxnumnp)
c
c=========  fem discretization interface =============
c
c
      common  / c3ndof /  ndof,nint,ntype
      common  / c3idal /  id(1,mxnumnp)
      common  / c3iida /  iid(1,mxnumnp)
      common  / c3fmtb /  tabl(mxnumnp)

      common  / c1bbbb /  r1bbbb(mneq)
      common  / c1coef /  r1coef(mneq,mnco)
      common  / c1idco /  i1idco(mneq,mnco)
      common  / c1ivdi /  i1neqn, i1mneq, i1ncoe, i1mnco

c
c========= other varaibles ==========================
c
      common  / c1ivcn /  level, ipage, inpt, iout
      common              wksp (mxnumnp, 3*nxx*nyy)
c 
c========= temp =====================================
c
      common / c1regn / reg(6)
      common / c2edge / hhh
      dimension hxyz(5),error(5)
c 
c====================================================
c
      data reg / 0.0,1.0,0.0,1.0,0.0,1.0/
      level = 1
      iout  = 6
c
      i1mneq= mneq
      i1mnco= mnco
      ndim  = ndimm
      nen   = 4
      ndof  = 1
c
c -------------------
      nint   = 5
      imax   = 4
      ideriv = 6
      iprint = 0
c -------------------
c
      do 9999 kk=1,imax
      ngridx = 2*kk + 1
      ngridy = ngridx
      ngridz = ngridx

c
      call mesh(ngridx, ngridy, ngridz,
     &		x,ibnod,ien,iben,ndim,nen,numel,numnp,
     &		iout,level)
c
      call lin3dfem
c
      itmx = i1neqn
      eps = 1.0E-07
      nwk = 3*i1mneq
*      call cg(i1neqn,i1mneq,i1ncoe,i1idco,r1coef,r1bbbb,y,
*     &        nwk,wksp,itmx,eps,level)
      call solve(i1mneq,i1neqn,i1ncoe,i1idco,r1coef,r1bbbb,wksp)
c 
      call errormax(x,ndim,i1neqn,numnp,id,ndof,tabl,err,
     &              r1bbbb,iout,level)
      hxyz(kk) = hhh
      error(kk) =err
c
      if(kk.eq.1) then
      print'(3x,50("=")
     &      /4x,"neqn",7x,"h",11x,"max.error",6x,"order.conv"
     &      /3x,50("-")
     &      /i7,3x,f10.7,2x,1pe15.7)',i1neqn,hhh,error(kk)
      else
         conv= alog(error(kk-1)/error(kk))/alog(hxyz(kk-1)/hhh)
         print'(i7,3x,f10.7,2x,1pe15.7,$)',i1neqn,hhh,error(kk)
         print'(7x,f6.3)',conv
      endif
      if(kk.eq.imax)print'(3x,50("=")/)'
c
      if(kk.eq.imax .and. iprint.eq.1)then
         call r3fill(tabl)
         nxeval = 5
         nyeval = 5
         nzeval = 5
         call eval(ideriv,hhh,ndof,nxeval,nyeval,nzeval)
      endif
c
 9999 continue
c
      stop
      end
c_______________________________________________________________________
