      subroutine lin3dfem
c================================================================
c... generates the FE eqautions for the second order self-adjoint
c    elliptic PDEs, defined in 3-dimensional space:
c
c         - div(p*grad(u)) + q*u = f     in \Omega
c                              u = g     in \Gamma_0
c                       un + s*u = k     in \Gamma_1
c INPUT:
c    mesh interface,
c    integration pts( nint = 1 or 4)
c         number of dofs per node( ndof=ned=1)
c         number of element nodes( nen=4)
c         number of element equations(nee=4)
c OUTPUT:
c    boundary condition data(id,iid,a,neqn)
c    fem equations(lhs: coef, idco ,rhs:rhs)
c================================================================
c
c ========  finite element mesh interface =======
c
      common / c1mhnu / ndim,nen,numel,numnp
      common / c1mhxy / x(1)
      common / c1mien / ien(1)
      common / c1mben / iben(1)
      common / c1bnod / ibnod(1)
c
c=========  liner fem discretization =============
c
      common / c3ndof / ndof,nint,ntype
      common / c3idal / id(1)
      common / c3iida / iid(1)
      common / c3fmtb / tabl(1)

c=========  discrete operator interface =============

      common / c1bbbb / rhs(1)
      common / c1coef / coef(1)
      common / c1idco / idco(1)
      common / c1ivdi / neqn, mneq, ncoe, mnco

c========= other varaibles ==========================
c
      common  / c1ivcn /  level, ipage, inpt, iout
c 
c====================================================
c
      call eqset(ndim,ndof,numnp,
     &           x,ibnod, id,iid,neqn,
     &           iout,level)
c
c.... forms global finite element equations
c.... computes Dirichlet boundary dofs and numbers equations
c
      call compbc(ndim,ndof,numnp,x,ibnod,id,tabl,iout,level)
c
c.... computes the coeficients of global fem equations and stores
c     them in band storage form
c
      call p1c0qb(nint, ndof, nen, ndim, numnp, numel,
     &         	 x, ien, iben, ibnod, id, iid, tabl,
     &           neqn, mneq, ncoe, mnco,
     &           coef, idco, rhs, 
     &           iout,level)
c     
      end
c_______________________________________________________________________
