      subroutine eqset(ndim,ndof,numnp,
     &                 x,ibnod, id,iid,neqn,
     &                 iout,level)
c
c 3-D Tetrahedra
c
c program to read, generate and write the boundary condition data at the
c boundary nodes of the fem mesh, and establish equation numbers
c
c INPUT:     
c  ibnod(nod) = 0 if ith node is interior 
c             = i1pece if the ith node is in the i1pece of the
c               boundary

c OUTPUT:
c  id(1,N) = 0, specified u(inactive dof)
c          = equation #, specified ux uy or un (active dof)
c  iid(1,N)= inverse mapping of id( , )
c
        dimension x(ndim,1), ibnod(1)
       	dimension id(ndof,1), iid(ndof,1)
        dimension r0cbc(4)
c
c.... generate the bc data
c
      do 130 nod= 1, numnp
	 if (ibnod(nod) .eq. 0) then 
	     id(1,nod) = 1 
         else
             ipiece = ibnod(nod)
             call q1bcoe(ipiece,x(1,nod),x(2,nod),x(3,nod),r0cbc)
c
             if(r0cbc(1).ne.0.0) id(1,nod) = 0        	 	
             if(r0cbc(2).ne.0.0) id(1,nod) = 1        	 	
             if(r0cbc(3).ne.0.0) id(1,nod) = 1        	 	
             if(r0cbc(4).ne.0.0) id(1,nod) = 1        	 	
         endif
 130  continue
        
c
c.... establish equation numbers
c.... note: ndof == 1 for linear discr.
c
         nnn = 0
         do 150 nod=1,numnp
            do 160 i=1,ndof
               if (id(i,nod) .eq. 1) then
                  nnn = nnn + 1
                  id(i,nod) = nnn
                  iid(i,nnn) = nod
               endif
 160        continue
 150     continue
         neqn= nnn
c
c
c.... print the results
c
      if(level.lt.5) return
c
      write(iout,*)
      write(iout,*) '*** From eqset.f ***'
      write(iout,*)
      write(iout,*) 'equation numbering :'
      write(iout,*) 'neqn= ',neqn
      write(iout,*)
      write(iout,*) 'equation numbering :'
      write(iout,*) 'inod= id'
      write(iout,*) (i,'=',id(1,i),'   ',i=1,numnp)
      write(iout,*)
      write(iout,*) 'equation numbering : inverse id '
      write(iout,*) 'id= iid'
      write(iout,*) (i,'=',iid(1,i),'   ',i=1,neqn)
c
      end
c_______________________________________________________________________
