      subroutine cg(neqn,mneq,ncoe,idco,coef,b,x,nwk,wksp,itmx,eps,levl)
 
c---- purpose of this subroutine---------------------------------------
c
c     This module finds the solution of sparse-matrix eqution by using
c     conjugate gradient (iterative) method.
c
c----------------------------------------------------------------------

c---- algorithm of conjugate gradient (iterative) method---------------
c 
c     x = x0
c     h = A x ; g = h - b ; det0 = g g 
c     IF det0 < eps THEN STOP
c     d = - g       
c  R: h= A d  ; tau = det0 / ( d h )
c     x = x + tau d ; g = g + tau h ; det1 = g g 
c     IF det1 < eps THEN STOP
c     bet = det1 / det0 ; det0 = det1 ; d = - g + bet d
c     GOTO R 
c
c----------------------------------------------------------------------

c---- arguments of this subroutine-------------------------------------
c
c     neqn  input integer.  dimension of the matrix in this subroutine.
c     mneq  input integer(>= neqn).  row dimension of idco and coef 
c           arrays in calling routine
c     ncoe  input integer.  column dimension of idco and coef arrays in
c           calling routine
c     idco  input integer array(mneq x ncoe) for sparse matrix 
c           representation
c     coef  input real array (mneq x ncoe)for sparse matrix represen- 
c           tation. idco and coef use the ellpack data structure.
c     b     input real vector(neqn) which contains the right hand side
c           of the matrix problem.
c     x     output real vector which contains each step approximation 
c           to the solution and finally last estimate to the solution.
c     nwk   input integer(>= 3*mneq).  length of available workspace.
c     wksp  real vector used for working space. 
c     itmx  input integer. maximum number of iterations allowed.
c     eps   input real number. tolerance as a stopping criteion.
c     levl  input integer(0-5). printing level for output. 
c
c----------------------------------------------------------------------

c
c.... declaration for arguments 
c
      integer  neqn, mneq, ncoe, nwk, itmx, idco(mneq,ncoe)
      real     eps, b(mneq), x(mneq), wksp(nwk), coef(mneq,ncoe)
c
c.... declaration local variables
c
      integer  g, d, h
      real     det0, det1, tau, bet
c
c.... print the name of module (level=1)
c
      if( levl .ge. 1 ) then  
        print'(///a17/a17/a17///)',
     &         '-----------------',
     &         ' solution module ',
     &         '-----------------'
        print*,' c o j u g a t e   g r a d i e n t' 
      endif
c
c.... print liner system (level=5)
c
      if( levl .ge. 5 ) then  
	print*
        print*,'----the linear system is as follows ----'
	print*
	print*,'idcoef array'
        do 200 i=1,neqn
            print'(1x,a4,i5,a3)','row ',i,' : '
            print'(10i7)',(idco(i,j),j=1,ncoe)
 200    continue
	print*

	print*,'coef array'
	do 205 i=1,neqn
            print'(1x,a4,i5,a3)','row ',i,' : '
            print'(5e12.4)',(coef(i,j),j=1,ncoe)
 205    continue
	print*

	print*,'rhs array'
        print'(5e12.4)',(b(j),j=1,neqn)
	print*

      endif
c
c.... chek the capacity of workspace (level=0)
c
      if( nwk .lt. 3*mneq )then
       print'(/a31)',       ' **************************************'
       print'(a31)',        ' ***** f a t a l   e r r o r **********'
       print'(a28,i4,a1)',  ' Workspace must be at least ',3*mneq,'.'
       print'(a31/)',       ' **************************************'
       stop
      endif
c
c....assign workspace to vectors  g, d, and h.  
c....where h = A d,  g = g + t h,  d = - g + bet d
c
      g=0*neqn
      d=1*neqn
      h=2*neqn
c
c....initialize approximation x of solution vector 
c
      do 105 i=1,neqn      
         x(i)= 1.  
 105  continue
*
c------------------ 0-th step of conjugate gradient -------------------
c
c....h = A x 
c... g = h - b   det0 = g g
c
      det0= 0.
      do 110 i=1,neqn      
         wksp(h+i)= 0.
         do 120 j=1,ncoe      
	    wksp(h+i)= wksp(h+i)+coef(i,j)*x(idco(i,j))  
 120     continue
	 wksp(g+i)= wksp(h+i)-b(i)
	 det0= det0 +wksp(g+i)**2
 110  continue
      iter=0
c
c.... print intermediate output (level=2)
c
      if( levl .ge. 2 ) then  
	print*
        print*,'----intermediate output after each iteration----'
	print*
        print*,'number of   square of norm of'
        print*,'iteration   residual(=Ax-b)'
	print'(i7,5x,e10.2)', iter,sqrt(det0)
      endif
c
c.... print intermediate output (level=4)
c
      if( levl .ge. 4 ) then  
	print*
        print*,'estimate of solution at iteration ',iter
        print'(5e12.4)',(x(j),j=1,neqn)
      endif
c
c....IF det0 < eps,THEN STOP 
c
      if( det0 .le. eps ) goto 55
c
c--------------- (iter)-th step of conjugate gradient --------------
c
c.... d = - g 
c
      do 130 i=1,neqn      
	 wksp(d+i)= - wksp(g+i)  
 130  continue
c
      do 7777 iter=1,itmx
c
c....h = A d  
c....tau = det0 / ( d h )
	 tau= 0.
         do 140 i=1,neqn      
	    wksp(h+i)= 0.
            do 150 j=1,ncoe      
	       wksp(h+i)=wksp(h+i)+coef(i,j)*wksp(d+idco(i,j))
 150        continue
	    tau= tau +wksp(d+i)*wksp(h+i)  
 140     continue
	 tau=det0/tau
c
c....x = x + tau d 
c....g = g + tau h
c....det1 = g g
         det1= 0.
         do 155 i=1,neqn      
   	    x(i)= x(i) +tau*wksp(d+i)
   	    wksp(g+i)= wksp(g+i) +tau*wksp(h+i)
	    det1= det1 +wksp(g+i)**2
 155     continue
c
c.... print intermediate output after each iteration(level=2)
c
      if( levl .ge. 2 ) then  
	print'(i7,5x,e10.2)', iter,det1
      endif
c
c.... print intermediate output after each iteration(level=4)
c
         if( levl .ge. 4 ) then  
            print*,'estimate of solution at iteration ',iter
            print'(5e12.4)',(x(j),j=1,neqn)
         endif
c
c.... IF det1 < eps,THEN STOP
c
         if( det1 .le. eps ) goto 55
c
c.... d = - g + bet d
c
	 bet=det1/det0
	 det0=det1
         do 160 i=1,neqn      
            wksp(d+i)= - wksp(g+i) + bet*wksp(d+i)  
 160     continue
c
 7777 continue
c
c....warning for insufficiency of max iteration "itmx" (lavel=1)
c
      if( levl .lt. 1 ) return
	print*
        print*,'*** w a r n i n g ************'
        print*,'in conjugate gradient module '
        print*,'failure to converge in ', itmx,' iterations'
c
c....print the number of iteration at which "cg" converged(level=1)
c
 55   continue
      if( levl .lt. 1 ) return
      print*
      print'(a22,i5,a11)',' cg  has converged in ',  iter,' iterations'
      print*
      print*,'execution successful'
      print*
c
      end
c_______________________________________________________________________

