c
c This file contains the functions and subroutines that 
c  user must supply.
c
      function head(x,y,z)
        head = x**2 + y**2 + z**2
      end
c_______________________________________________________________________
        subroutine q1pcoe(x,y,z,r0cpde)
c
c   - { P*(Uxx + Uyy + Uzz) + Px*Ux + Py*Uy + Pz*Uz } + Q*U = f
c
c     c1*Uxx + c2*Uxy + c3*Uyy + c4*Ux + c5*Uy + c6*U
c   + c7*Uzz + c8*Uyz + c9*Uzx + c10*Uz = f  ( ELLPACK Structure )
c
c  NOTE: c1=c3=c7=-P  c2=c8=c9=0  c4=-Px c5=-Py c10=-Pz c6=Q
c   for FEM module for the self-adjoint elliptic PDEs.
c
        dimension r0cpde(10)
c
        r0cpde(1) = -1.
        r0cpde(2) =  0.
        r0cpde(3) = -1.
        r0cpde(4) =  0.
        r0cpde(5) =  0.
        r0cpde(6) = 10.
        r0cpde(7) = -1.
        r0cpde(8) =  0.
        r0cpde(9) =  0.
        r0cpde(10)=  0.
        return
        end
c_______________________________________________________________________
        real function r1prhs(x,y,z)
        r1prhs=  10.*head(x,y,z) -6.
        return
        end
c=======================================================================
       subroutine q1bcoe(i0side,x,y,z,r0cbc)
c
c       r0cbc(1) = coef of u
c       r0cbc(2) = coef of ux
c       r0cbc(3) = coef of uy
c       r0cbc(4) = coef of uz
c
        dimension r0cbc(4)
c
        i0bcnd = i0side
        go to(1001,1002,1003,1004,1005,1006), i0bcnd
1001    continue
        r0cbc(1) =  1.
        r0cbc(2) =  1.
        r0cbc(3) =  0.
        r0cbc(4) =  0.
        goto 9999
1002    continue
        r0cbc(1) =  1.
        r0cbc(2) =  1.
        r0cbc(3) =  0.
        r0cbc(4) =  0.
        goto 9999
1003    continue
        r0cbc(1) =  1.
        r0cbc(2) =  0.
        r0cbc(3) =  1.
        r0cbc(4) =  0.
        goto 9999
1004    continue
        r0cbc(1) =  1.
        r0cbc(2) =  0.
        r0cbc(3) =  1.
        r0cbc(4) =  0.
        goto 9999
1005    continue
        r0cbc(1) =  1.
        r0cbc(2) =  0.
        r0cbc(3) =  0.
        r0cbc(4) =  1.
        goto 9999
1006    continue
        r0cbc(1) =  1.
        r0cbc(2) =  0.
        r0cbc(3) =  0.
        r0cbc(4) =  1.
        goto 9999
9999    return
        end
c_______________________________________________________________________
        function r1brhs(i0side,x,y,z)
c
        i0bcnd = i0side
        go to(1001,1002,1003,1004,1005,1006), i0bcnd
1001    continue
        r1brhs = head(x,y,z)+2.*x
        goto 9999
1002    continue
        r1brhs = head(x,y,z)+2.*x
        goto 9999
1003    continue
        r1brhs = head(x,y,z)+2.*y
        goto 9999
1004    continue
        r1brhs = head(x,y,z)+2.*y
        goto 9999
1005    continue
        r1brhs = head(x,y,z)+2.*z
        goto 9999
1006    continue
        r1brhs = head(x,y,z)+2.*z
        goto 9999
9999    return
        end
c_______________________________________________________________________
